//#define DEBUG
/*

   MZ-700 Emulator

     (C) by BKK

*/

#define VERSION "0.35"

#include <stdio.h>
#include <string.h>
#include <io.h>
#include <conio.h>
#include <dos.h>
#include <mem.h>
#include <time.h>
#include <process.h>
#include <sys/farptr.h>
#include <sys/movedata.h>
#include <sys/segments.h>
#include <pc.h>
#include <dpmi.h>
#include <go32.h>
#include <ctype.h>
#include <dir.h>
#include <bios.h>
#include <unistd.h>
#include <errno.h>

#include "../BKK-KBD/KeyBoard.h"
#include "../RAZE/RAZE.h"

#include "MZ-700.h"


#include "MZ-1E05/MZ-1E05.h"     // FD
#include "MZ-1E14/MZ-1E14.h"     // QD
#include "MZ-1E24/MZ-1E24.h"     // SIO
#include "MZ-1R12/MZ-1R12.h"     // RAM-Disc

#include "KuP_80Z/KuP_80Z.h"     // Kersten und Partner 80 Zeichenkarte

#define MAXCOL 40
#define MAXROW 25




UINT32 ClockTicks;
UINT32 Z80ClockTicks;


unsigned char CursorStartLine;
unsigned char CursorEndLine;

unsigned char SoundOn = TRUE;
unsigned char IntroOn = TRUE;
UINT16 BrakeValue = 0;
unsigned char BrakeValueChanged = FALSE;

unsigned char E008_Strobe = 0;
unsigned char VBlank;
unsigned char VBlankFlag;
unsigned char CursorBlink = FALSE;

unsigned char JoyStickInitOn = TRUE;
unsigned char JoyStick = FALSE;
unsigned short Joy[4];

unsigned short JoyMinimum[4];
unsigned short JoyCenter[4];
unsigned short JoyMaximum[4];


unsigned char PrinterPort = 0;
unsigned char RDAFlag = 0;
FILE *PFile = NULL;
unsigned char PltMode = TRUE;
unsigned char PltFileNumber;
unsigned short PltSequence;
unsigned char PltGraphMode = FALSE;
unsigned char PltPenInUse = 0;
short PltHomeXPos = 0;
short PltHomeYPos = 0;
short PltAbsXPos = 0;
short PltAbsYPos = 0;
#define PLTCHARWIDTH(x) (12.0 / (x) / 2.0)
#define PLTCHARHEIGHT(x) (12.0 / (x))
unsigned char PltParaCounter = 0;
unsigned char PltParaIndex = 0;
unsigned char PltParaIsOk = TRUE;
struct PltPara
{
 char Value[5];
} PltParameter[3];


unsigned char PlayPressed = FALSE;
unsigned char CMTReadAccess = 0;
unsigned char CMTBitMask = 0x80;
unsigned char CMTByte;
unsigned char CMTMode = CMTREADMODE;
int CMTBitClockTicks;
int CMTBitShortClockTicks;
int CMTBitLongClockTicks;

FILE *CMTFile = NULL;



int New1ESegOffs;
int New1ESelector;
__dpmi_raddr Org1EIntAddr, New1EIntAddr;
unsigned char New1EInt[] = {0xDF, 0x02, 0x25, 0x01, 16, 0x2A, 0xFF, 0x50, 0xE5, 100, 4};


char MZFPath[80] = "";
char MZTPath[80] = "";

char FontFile[20] = "MZ7CGInt.ROM";

UINT16 MZFrequenz;

UINT16 Counter0Init;
UINT16 Counter0Value;
UINT16 Counter1Init;
UINT16 Counter1Value;
UINT16 Counter2Init;
UINT16 Counter2Value;
UINT8 FirstCounter2Zero;
UINT8 ReadWriteMSB = 0;
UINT8 CounterMode = 0;


UINT8 KeyPA;

UINT8 WDATA;                // PC1
UINT8 INTMSK;               // PC2
UINT8 M_ON = FALSE;         // PC3
UINT8 M_STATUS = MOTORSTOP; // PC4


UINT8 MZRAM[0x10000];

UINT8 MZMonROM[0x1000 - 0x0000];
UINT8 MZCGROM[0x2000 - 0x1000];
UINT8 MZCGRAM[0xD000 - 0xC000];
UINT8 MZVRAM[0xE000 - 0xD000];
UINT8 MZExtROM[0x10000 - 0xE000];


unsigned char RAMDFStatus;      // 0xD000 - 0xFFFF (VRAM, I/O or RAM)
unsigned char RAMDFSaveStatus;


UINT8 MZKBDIndex;

UINT8 KBDArray[10][8] =
{
 { SCAN_ENTER, SCAN_QUOTA, SCAN_SCOLON,    SCAN_TAB,    SCAN_ALT, /* Pound */ 0, SCAN_CAPSLOCK, /*Blank*/ 0},
 {          0,           0,          0, SCAN_BSLASH, SCAN_RANGLE,    /* at */ SCAN_LANGLE,        SCAN_Z,      SCAN_Y},
 {     SCAN_X,      SCAN_W,     SCAN_V,      SCAN_U,      SCAN_T,        SCAN_S,        SCAN_R,      SCAN_Q},
 {     SCAN_P,      SCAN_O,     SCAN_N,      SCAN_M,      SCAN_L,        SCAN_K,        SCAN_J,      SCAN_I},
 {     SCAN_H,      SCAN_G,     SCAN_F,      SCAN_E,      SCAN_D,        SCAN_C,        SCAN_B,      SCAN_A},
 {     SCAN_8,      SCAN_7,     SCAN_6,      SCAN_5,      SCAN_4,        SCAN_3,        SCAN_2,      SCAN_1},
 {   SCAN_DOT,   SCAN_COMA,     SCAN_9,      SCAN_0,  SCAN_SPACE,       SCAN_SS,   SCAN_EQUALS, SCAN_BACKSP},
 { SCAN_MINUS, SCAN_RSHIFT,  SCAN_LEFT,  SCAN_RIGHT,   SCAN_DOWN,       SCAN_UP,   SCAN_DELETE, SCAN_INSERT},
 {SCAN_LSHIFT,           0,          0,           0,           0,             0,    SCAN_LCTRL,    SCAN_ESC},
 {          0,           0,          0,     SCAN_F5,     SCAN_F4,       SCAN_F3,       SCAN_F2,     SCAN_F1}
};


UINT8 MZColToPC[16] = {0x00, 0x01, 0x04, 0x05, 0x02, 0x03, 0x06, 0x07, 0x08, 0x09, 0x0C, 0x0D, 0x0A, 0x0B, 0x0E, 0x0F};

unsigned short B800;





#ifdef DEBUG
FILE *DebugFile;
#endif



char Mirror(char Byte)
{
 unsigned char SetMask = 0x80;
 unsigned char GetMask = 0x01;
 unsigned char i;
 char Result = 0;


 for(i = 0; i < 8; i++)
 {
  if((Byte & GetMask) != 0) Result = Result | SetMask;
  SetMask = SetMask >> 1;
  GetMask = GetMask << 1;
 }

 return Result;
}




void CGRAMToVGA(void)
{
 /*
  *  Copy the MZ-CharacterFont (CG-RAM) into the VGA-Card
  *
  */

 __dpmi_regs Register;
 unsigned char MZMirrorCGRAM[4096];
 unsigned short i;

 for(i = 0; i < 4096; i++) MZMirrorCGRAM[i] = Mirror(MZCGRAM[i]);


 dosmemput(&MZMirrorCGRAM[0], 0x800, __tb);

 Register.h.ah = 0x11;
 Register.h.al = 0x10;
 Register.h.bh = 8;     // 8 scan lines
 Register.h.bl = 0;     // in table 0
 Register.x.cx = 256;   // 256 characters
 Register.x.dx = 0;     // first character is ASCII 0
 Register.x.es = __tb >> 4;
 Register.x.bp = __tb & 0x0F;
 __dpmi_int(0x10, &Register);


 dosmemput(&MZMirrorCGRAM[0x800], 0x800, __tb);

 Register.h.ah = 0x11;
 Register.h.al = 0x00;
 Register.h.bh = 8;     // 8 scan lines
 Register.h.bl = 1;     // in table 1
 Register.x.cx = 256;   // 256 characters
 Register.x.dx = 0;     // first character is ASCII 0
 Register.x.es = __tb >> 4;
 Register.x.bp = __tb & 0x0F;
 __dpmi_int(0x10, &Register);


 Register.h.ah = 0x11;
 Register.h.al = 0x03;
 Register.h.bl = 0x04;
 __dpmi_int(0x10, &Register);

 // Cursor off (have placed here, of course above INT's switches cursor on)
 Register.h.ah = 0x01;
 Register.x.cx = 0x2100;
 __dpmi_int(0x10, &Register);
}




unsigned char ReadJoyStickAxis(void)
{
 unsigned char Result;


 Joy[0] = 0;
 Joy[1] = 0;
 Joy[2] = 0;
 Joy[3] = 0;


 // for gcc 3.10 we need the \n\ at the end of each line

 __asm__ __volatile__ ("cli               \n\
                                          \n\
                       push %%bp          \n\
                                          \n\
                       movw $0x1000, %%cx \n\
                                          \n\
                       xor %%bx, %%bx     \n\
                       xor %%dx, %%dx     \n\
                       xor %%di, %%di     \n\
                       xor %%si, %%si     \n\
                                          \n\
                       mov %%dx, %%bp     \n\
                       movw $0x201, %%dx  \n\
                       outb %%al, %%dx    \n\
                       mov %%bp, %%dx     \n\
                                          \n\
CountLoop:                                \n\
                       mov %%dx, %%bp     \n\
                       movw $0x201, %%dx  \n\
                       inb %%dx, %%al     \n\
                       mov %%bp, %%dx     \n\
Bit0:                                     \n\
                       shr $1,%%al        \n\
                       adcw $0, %0        \n\
Bit1:                                     \n\
                       shr $1,%%al        \n\
                       adcw $0, %1        \n\
Bit2:                                     \n\
                       shr $1,%%al        \n\
                       adcw $0, %2        \n\
Bit3:                                     \n\
                       shr $1,%%al        \n\
                       adcw $0, %3        \n\
                                          \n\
                       loop CountLoop     \n\
                                          \n\
                       pop %%bp           \n\
                                          \n\
                       sti"
  : "=b" (Joy[0]), "=d" (Joy[1]), "=D" (Joy[2]), "=S" (Joy[3])
 );

 Result = 0;
 if((Joy[0] != 4096) || (Joy[1] != 4096)) Result++;
 if((Joy[2] != 4096) || (Joy[3] != 4096)) Result++;

 return(Result);
}




void NormalizeJoyStick(void)
{
 unsigned char Counter;


 for(Counter = 0; Counter < 4; Counter++)
 {
  if(JoyCenter[Counter] != 0)
  {
   if(Joy[Counter] < JoyCenter[Counter])
   {
    if(Joy[Counter] < JoyMinimum[Counter]) Joy[Counter] = JoyMinimum[Counter];
    Joy[Counter] = ((Joy[Counter] - JoyMinimum[Counter]) * 128) / (JoyCenter[Counter] - JoyMinimum[Counter]);
   }
   else
   {
    if(Joy[Counter] > JoyMaximum[Counter]) Joy[Counter] = JoyMaximum[Counter];
    Joy[Counter] = ((Joy[Counter] - JoyCenter[Counter]) * 128) / (JoyMaximum[Counter] - JoyCenter[Counter]) + 128;
   }
  }
 }
}




void InitJoyStick(void)
{
 unsigned char Counter;
 unsigned char JoyStickCounter;
 unsigned char NumberOfJoySticks;

 char IniLine[40];


 for(Counter = 0; Counter < 4; Counter++)
 {
  JoyMinimum[Counter] = 0;
  JoyCenter[Counter] = 0;
  JoyMaximum[Counter] = 0;
 }

 NumberOfJoySticks = ReadJoyStickAxis();

 if(NumberOfJoySticks != 0)
 {
  clrscr();

  while(kbhit()) getch();

  gotoxy(5,5);
  if(NumberOfJoySticks == 1)
   printf("One Joystick was detected. Now it will be calibrated:\n\n");
  else
   printf("Two Joysticks were detected. Now they will be calibrated:\n\n");

  for(JoyStickCounter = 1; JoyStickCounter <= NumberOfJoySticks; JoyStickCounter++)
  {
   printf("Move stick %u in the upper left corner than press any key.\n", JoyStickCounter);
   while(!kbhit());
   while(kbhit()) getch();
   (void) ReadJoyStickAxis();
   for(Counter = JoyStickCounter * 2 - 2; Counter < JoyStickCounter * 2; Counter++)
    JoyMinimum[Counter] = Joy[Counter];

   printf("Move stick %u in the center position than press any key.\n", JoyStickCounter);
   while(!kbhit());
   while(kbhit()) getch();
   (void) ReadJoyStickAxis();
   for(Counter = JoyStickCounter * 2 - 2; Counter < JoyStickCounter * 2; Counter++)
    JoyCenter[Counter] = Joy[Counter];

   printf("Move stick %u in the lower right corner than press any key.\n", JoyStickCounter);
   while(!kbhit());
   while(kbhit()) getch();
   (void) ReadJoyStickAxis();
   for(Counter = JoyStickCounter * 2 - 2; Counter < JoyStickCounter * 2; Counter++)
    JoyMaximum[Counter] = Joy[Counter];
  }

  for(Counter = 0; Counter < NumberOfJoySticks; Counter++)
  {
   sprintf(IniLine, "JoyStick%c=%u,%u,%u,%u,%u,%u\n", Counter + '1', JoyMinimum[Counter * 2], JoyCenter[Counter * 2], JoyMaximum[Counter * 2], JoyMinimum[Counter * 2 + 1], JoyCenter[Counter * 2 + 1], JoyMaximum[Counter * 2 + 1]);
   UpdateIni(IniLine);
  }

 }
}




UINT8 MZIORead(UINT32 Address)
{
 UINT8 Result;
 UINT8 Counter;
 UINT8 Mask;


 Result = 0xFF;

 switch(Address)
 {
  case 0xE000: /* 8255 PORT A (KEYPA) */
               Result = KeyPA;
               break;

  case 0xE001: /* 8255 PORT B (KEYPB) */
               Result = 0xFF;
               Mask = 0x01;
               for(Counter = 0; Counter < 8; Counter++)
               {
                if(keyboard_key_down(KBDArray[MZKBDIndex][Counter]) != 0) Result = Result & ~Mask;
                Mask = Mask << 1;
               }
               break;

  case 0xE002: /* 8255 PORT C (KEYPC) */
               Result = 0xEF;
               if(inportb(0x3DA) & 0x08)    // PC7 = VBLK#0
               {
                Result = Result & 0x7F;
                VBlankFlag = 0xAA;
               }
               else VBlankFlag = 0x55;

               if(CursorBlink) Result = Result & 0xBF;           // PC6 = CursorTimer

               if(M_STATUS != MOTORSTOP)
               {
                Result = Result | 0x10; // PC4 = Motor on

                if(++CMTReadAccess == 4) CMTReadAccess = 1;
                if(CMTReadAccess == 1) Result = Result & 0xDF;
                if(CMTReadAccess == 3)
                {
                 if(CMTBitMask == 0)
                 {
                  if((CMTFile == NULL) || feof(CMTFile) || (CMTMode == CMTWRITEMODE)) (void) OpenCMTReadFile(MZT);
                  if(CMTFile != NULL) CMTByte = fgetc(CMTFile);
                  CMTBitMask = 0x80;
                 }
                 if((CMTByte & CMTBitMask) == 0) Result = Result & 0xDF;
                 CMTBitMask = CMTBitMask >> 1;
                }
               }
               break;

  case 0xE003: /* 8255 CONTROL (KEYPF) */
               /* to read the 8255 Mode-Register is illegal */
               Result = 0xFF;
               break;

  case 0xE004: /* 8253 CONT0 */
               Result = 0;
               break;

  case 0xE005: /* 8253 CONT1 */
               Result = 0;
               if(ReadWriteMSB) Result = Counter2Value >> 8;
               else Result = Counter2Value & 0xFF;
               ReadWriteMSB ^= 1;
               break;

  case 0xE006: /* 8253 CONT2 */
               Result = 0;
               if(ReadWriteMSB) Result = Counter2Value >> 8;
               else Result = Counter2Value & 0xFF;
               ReadWriteMSB ^= 1;
               break;

  case 0xE007: /* 8253 CONTF */
               // TO DO !!!
               break;

  case 0xE008:
               Result = 0xEE;

               // Tempo (D0)
               Result = Result | E008_Strobe;

               // Joystick (D1...D4)
               if(VBlankFlag == 0x55)   // process switches
               {
                Result = Result & 0xF1;
                Result = Result | ((inportb(0x201) & 0xF0) >> 3);
               }

               if(VBlankFlag == 0xAA)
               {
                ReadJoyStickAxis();
                NormalizeJoyStick();
                VBlankFlag = 0xBB;
               }

               if(VBlankFlag == 0xBB)
               {
                if(Joy[0] != 0)
                {
                 Result = Result & 0xFD;
                 Joy[0]--;
                }
                if(Joy[1] != 0)
                {
                 Result = Result & 0xFB;
                 Joy[1]--;
                }
                if(Joy[2] != 0)
                {
                 Result = Result & 0xF7;
                 Joy[2]--;
                }
                if(Joy[3] != 0)
                {
                 Result = Result & 0xEF;
                 Joy[3]--;
                }
               }

               // D5 and D6 are not used! Default = 1

               // HSYNC# (D7)
               if((inportb(0x3DA) & 0x09) == 0x01) Result = Result & 0x7F;

               break;

  default:
               Result = 0xFF;
 }
 return(Result);
}




UINT8 MZRAMDFRead(UINT32 Address)
{
 switch(RAMDFStatus)
 {
  case RAM       : return(MZRAM[Address]);
                   break;

  case PROHIBITED: return(0xFF);
                   break;

  case ROM       : //if(Address < 0xE000) return(MZVRAMRead(Address));
                   //else
                   //{
                    if(Address < 0xE070) return(MZIORead(Address));
                    else return(MZExtROM[Address - 0xE000]);
                   //}
                   break;
 }

 return(0xFF);
}




UINT8 MZColorToPC(UINT8 Data)
{
 return MZColToPC[Data & 0x0F] << 4 | MZColToPC[Data >> 4];
}




void MZRAMWriteDE(UINT32 Address, UINT8 Data)
{
 if(RAMDFStatus == ROM)
 {
/*
  while(!(inportb(0x3DA) & 0x01));
  while((inportb(0x3DA) & 0x01));
*/

  if(Address <= 0xD3E7)
   _farpokeb(B800, (Address & 0xFFF) << 1, Data);

  if(Address >= 0xD800 && Address <= 0xDBE7)
   _farpokeb(B800, ((Address & 0x7FF) << 1) + 1, MZColorToPC(Data));

  MZVRAM[Address - 0xD000] = Data;
 }
 else if(RAMDFStatus == RAM) MZRAM[Address] = Data;
}




void MZTapeMotorControl(void)
{
 if(!M_ON)
 {
  M_ON = TRUE;
  if(PlayPressed)
  {
   if(M_STATUS == MOTORSTOP)
   {
//    CMTBitShortClockTicks = 10000;
//    CMTBitLongClockTicks = 0;
    M_STATUS = MOTORON;
    keyboard_led(SCROLLLOCKLED + CAPSLOCKLED);
   }
   else
   {
    M_STATUS = MOTORSTOP;
    keyboard_led(SCROLLLOCKLED);
   }
  }
 }
}




void MZRAMWriteEF(UINT32 Address, UINT8 Data)
{
 UINT8 Set;


 if(RAMDFStatus != PROHIBITED)
 {
  if(RAMDFStatus == RAM) MZRAM[Address] = Data;
  else
  {
   if(Address < 0xE010)
   {
    switch(Address)
    {
     case 0xE000 : /* KEYPA */
                   KeyPA = Data;
                   MZKBDIndex = Data & 0X0F;
                   if(MZKBDIndex > 9) MZKBDIndex = 9;
                   break;

     case 0xE001 : /* KEYPB */
                   /* is input port */
                   break;

     case 0xE002 : /* KEYPC */
                   /* Bit 0 is unused */
                   WDATA = Data & 0x02;
                   INTMSK = Data & 0x04;
                   if(Data & 0x08) MZTapeMotorControl();
                   else M_ON = FALSE;
                   /* Bits 4...7 are inputs */
                   break;

     case 0xE003 : /* KEYPF */
                   if(Data < 0x80)       // PortC Bits
                   {
                    Data = Data & 0x0F;
                    Set = Data & 0x01;

                    switch(Data >> 1)
                    {
                     case 0x00 : /* not used */
                                 break;
                     case 0x01 : if((CMTFile == NULL) || (CMTMode == CMTREADMODE)) OpenCMTWriteFile();
                                 if(Set)
                                 {
                                  CMTBitClockTicks = z80_get_cycles_elapsed() * -1;
                                  WDATA = TRUE;
                                 }
                                 else
                                 {
                                  CMTBitClockTicks += z80_get_cycles_elapsed();
                                  
                                  if(CMTBitClockTicks < CMTBitShortClockTicks)
                                  {
                                   CMTBitShortClockTicks = CMTBitClockTicks;
#ifdef DEBUG
 fprintf(DebugFile, "ShortClocks: %i\n", CMTBitShortClockTicks);
#endif                                   
                                  }

                                  if(CMTBitClockTicks > CMTBitLongClockTicks)
                                  {
                                   CMTBitLongClockTicks = CMTBitClockTicks;
#ifdef DEBUG
 fprintf(DebugFile, "LongClocks: %i\n", CMTBitLongClockTicks);
#endif                                   
                                  }                                  
                                  
                                  if(CMTBitClockTicks < 1200) CMTByte = CMTByte & ~CMTBitMask;
                                  else CMTByte = CMTByte | CMTBitMask;
                                  CMTBitMask = CMTBitMask >> 1;
                                  if(CMTBitMask == 0)
                                  {
                                   CMTBitMask = 0x80;
                                   fputc(CMTByte, CMTFile);
                                  }
                                  WDATA = FALSE;
                                 }
                                 break;
                     case 0x02 : if(Set) INTMSK = TRUE;
                                 else INTMSK = FALSE;
                                 break;
                     case 0x03 : if(Set) MZTapeMotorControl();
                                 else M_ON = FALSE;
                                 break;
                    }
                   }
                   break;

     case 0xE004 : /* CONT0 */
                   if(ReadWriteMSB) MZFrequenz = (MZFrequenz & 0x00FF) | (Data << 8);
                   else MZFrequenz = (MZFrequenz & 0xFF00) | Data;
                   ReadWriteMSB ^= 1;
                   outportb(0x61, inportb(0x61) | 0x01);
                   break;

     case 0xE005 : /* CONT1 */
                   if(ReadWriteMSB) Counter1Init = (Counter1Init & 0x00FF) | (Data << 8);
                   else Counter1Init = (Counter1Init & 0xFF00) | Data;
                   Counter1Value = Counter1Init;
                   ReadWriteMSB ^= 1;
                   break;

     case 0xE006 : /* CONT2 */
                   if(ReadWriteMSB) Counter2Init = (Counter2Init & 0x00FF) | (Data << 8);
                   else Counter2Init = (Counter2Init & 0xFF00) | Data;
                   Counter2Value = Counter2Init;
                   ReadWriteMSB ^= 1;
                   break;

     case 0xE007 : /* CONTF */
                   ReadWriteMSB = FALSE;
                   CounterMode = Data;
                   if((CounterMode & 0xCE) == 0) // Counter 0 Mode 0
                    outportb(0x61, (inportb(0x61) & 0xFE) & 0xFD);
                   else            // Counter 0 Mode > 0
                    outportb(0x61, (inportb(0x61) & 0xFE) | 0x02);
                   break;

     case 0xE008 : if((Data & 0x01) && SoundOn) sound((1108800 / MZFrequenz));
                   else nosound();
                   break;

     default:      break;

    }
   }
  }
 }
}




void MZMemoryBank_Write(UINT16 Address, UINT8 Data)
{
 switch(Address)
 {
  case 0xE0 :
              z80_map_fetch(0x0000, 0x0FFF, &MZRAM[0x0000]);
              z80_map_read(0x0000, 0x0FFF, &MZRAM[0x0000]);
              
              z80_map_read(0x1000, 0x1FFF, &MZRAM[0x1000]);
              break;

  case 0xE1 :
              z80_map_fetch(0xE000, 0xFFFF, &MZRAM[0xE000]);
              z80_map_read(0xE100, 0xFFFF, &MZRAM[0xE100]);
              RAMDFStatus = RAM;

              z80_map_read(0xD000, 0xDFFF, &MZRAM[0xD000]);
              RAMDFSaveStatus = FREE;
              break;

  case 0xE2 :
              z80_map_fetch(0x0000, 0x0FFF, &MZMonROM[0]);
              z80_map_read(0x0000, 0x0FFF, &MZMonROM[0]);
              break;

  case 0xE3 :
              z80_map_fetch(0xE000, 0xFFFF, &MZExtROM[0x0000]);
              z80_map_read(0xE100, 0xFFFF, &MZExtROM[0x0100]);

              z80_map_read(0xD000, 0xDFFF, &MZVRAM[0]);
              RAMDFStatus = ROM;
              RAMDFSaveStatus = FREE;
              break;

  case 0xE4 :
              z80_map_fetch(0x0000, 0x0FFF, &MZMonROM[0]);
              z80_map_read(0x0000, 0x0FFF, &MZMonROM[0]);
              
              z80_map_read(0x1000, 0x1FFF, &MZRAM[0x1000]);

              z80_map_read(0xC000, 0xCFFF, &MZRAM[0xC000]);
              z80_map_write(0xC000, 0xCFFF, &MZRAM[0xC000]);
              
              z80_map_fetch(0xE000, 0xFFFF, &MZExtROM[0x0000]);
              z80_map_read(0xD000, 0xDFFF, &MZVRAM[0]);
              z80_map_read(0xE100, 0xFFFF, &MZExtROM[0x0100]);
              RAMDFStatus = ROM;
              RAMDFSaveStatus = FREE;
              break;

  case 0xE5 :
              RAMDFSaveStatus = RAMDFStatus;
              RAMDFStatus = PROHIBITED;
              break;

  case 0xE6 :
              RAMDFStatus = RAMDFSaveStatus;
              RAMDFSaveStatus = FREE;
              break;
 }
}




UINT16 MZMemoryBank_Read(UINT16 Address)
{
 switch(Address)
 {
  case 0xE0:
             z80_map_read(0x1000, 0x1FFF, &MZCGROM[0]);

             z80_map_read(0xC000, 0xCFFF, &MZCGRAM[0]);
             z80_map_write(0xC000, 0xCFFF, &MZCGRAM[0]);
             break;

  case 0xE1:
             z80_map_read(0x1000, 0x1FFF, &MZRAM[0x1000]);

             z80_map_read(0xC000, 0xCFFF, &MZRAM[0xC000]);
             z80_map_write(0xC000, 0xCFFF, &MZRAM[0xC000]);
  
             CGRAMToVGA();
             break;
 }

 return 0xFF;
}




UINT16 MZPIO_Read(UINT16 Address)
{
 UINT16 Result;


 Result = 0;

 switch(Address)
 {
  case PORTACTRL:
                  break;
  case PORTBCTRL:
                  break;
  case PORTADATA:
                  Result = 0x00 | RDAFlag;
                  RDAFlag = 0;
                  break;
  case PORTBDATA:
                  break;
 }

 return(Result);
}




UBYTE IO_Read(UWORD Address)
{
 UBYTE Result;


 Result = 0xFF;               // with 0 Nakamoto think a joystick is active
                              // Nakamoto is for 700 and 800 ?!
 Address = Address & 0x00FF;

 switch(Address)
 {
  case 0x70:
  case 0x71:
  case 0x72:
  case 0x73:
            if(KuP_80Z) Result = KuP_80Z_Read(Address);
            break;
  case 0xB0:
  case 0xB1:
  case 0xB2:
  case 0xB3:
            if(MZ1E24) Result = MZ1E24_Read(Address);
            break;
  case 0xD8:
  case 0xD9:
  case 0xDA:
  case 0xDB:
  case 0xDC:
  case 0xDD:
  case 0xDE:
            if(MZ1E05) Result = MZ1E05_Read(Address);
            break;
  case 0xE0:
  case 0xE1:
            Result = MZMemoryBank_Read(Address);
            break;
  case 0xF4:
  case 0xF5:
  case 0xF6:
  case 0xF7:
            if(MZ1E14) Result = MZ1E14_Read(Address);
            break;
  case 0xF8:
  case 0xF9:
            if(MZ1R12) Result = MZ1R12_Read(Address);
            break;
  case 0xFC:
  case 0xFD:
  case 0xFE:
  case 0xFF:
            Result = MZPIO_Read(Address);
            break;
  
 }

 return(Result);
}




void IO_Write(UWORD Address, UBYTE Data)
{
 Address = Address & 0x00FF;

 switch(Address)
 {
  case 0x70:
  case 0x71:
  case 0x72:
  case 0x73:
            if(KuP_80Z) KuP_80Z_Write(Address, Data);
            break;
  case 0xB0:
  case 0xB1:
  case 0xB2:
  case 0xB3:
            if(MZ1E24) MZ1E24_Write(Address, Data);
            break;
  case 0xD8:
  case 0xD9:
  case 0xDA:
  case 0xDB:
  case 0xDC:
  case 0xDD:
  case 0xDE:
            if(MZ1E05) MZ1E05_Write(Address, Data);
            break;
  case 0xE0:
  case 0xE1:
  case 0xE2:
  case 0xE3:
  case 0xE4:
  case 0xE5:
  case 0xE6:
            MZMemoryBank_Write(Address, Data);
            break;
  case 0xF4:
  case 0xF5:
  case 0xF6:
  case 0xF7:
            if(MZ1E14) MZ1E14_Write(Address, Data);
            break;
  case 0xF8:
  case 0xF9:
  case 0xFA:
            if(MZ1R12) MZ1R12_Write(Address, Data);
            break;
  case 0xFC:
  case 0xFD:
  case 0xFE:
  case 0xFF:
            MZPIO_Write(Address, Data);
            break;
 }
}




void PltClearFiles(void)
{
 unsigned char Number;
 char FileName[] = "MZ700-X.PLT";


 for(Number = 1; Number < 10; Number++)
 {
  FileName[6] = Number + '0';
  if(!access(FileName, F_OK)) remove(FileName);
 }
 PltFileNumber = 0;
}




void PltOpenNewFile(void)
{
 char FileName[] = "MZ700-X.PLT";

 
 if(PFile != NULL) fclose(PFile);
 PltFileNumber++;
 FileName[6] = PltFileNumber + '0';
 PFile = fopen(FileName, "wt");
 fputs("IN;IP0,0,3600,15100;SC0,480,-999,999;PA0,0;DI1,0;SP1;\n", PFile);
 fprintf(PFile, "SI%1.3f,%1.3f;\n", PLTCHARWIDTH(40), PLTCHARHEIGHT(40));
}




void PltAxis(void)
{
 unsigned char Axis;
 short Length;
 unsigned char Number;
 unsigned char Counter;


 Axis = (unsigned char) atoi(PltParameter[0].Value);
 Length = atoi(PltParameter[1].Value);
 Number = (unsigned char) atoi(PltParameter[2].Value);

 fputs("PD;\n", PFile);
 
 for(Counter = Number; Counter != 0; Counter--)
 {
  if(Axis == 0)
  {
   if(Counter != 1) fprintf(PFile, "PR0,%d,-2,0,+4,0,-2,0;\n", Length);
   else fprintf(PFile, "PR0,%d;\n", Length);
   PltAbsYPos = PltAbsYPos + Length;
  }
  else
  {
   if(Counter != 1) fprintf(PFile, "PR%d,0,0,-2,0,+4,0,-2;\n", Length);
   else fprintf(PFile, "PR%d,0;\n", Length);
   PltAbsXPos = PltAbsXPos + Length;
  }
 }

 fputs("PU;\n", PFile);
}




unsigned char TranslateSharpASCII(unsigned char Character)
{
 unsigned char Result;
 unsigned char Table[] = {
                          '}', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '^', 0, 0, 0, 0,
                          0, 0, 'e', '`', '~', 0, 't', 'g', 'h', 0, 'b', 'x', 'd', 'r', 'p', 'c',
                          'q', 'a', 'z', 'w', 's', 'u', 'i', 0, '', 'k', 'f', 'v', 0, '', '', 'j',
                          'n', 0, '', 'm', 0, 0, 0, 'o', 'l', '', '', '', 0, 'y', '{', 0,
                          0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x5F,
                          0, 0, 0, 0, 0, 0, 0, 0xEE, 0, 0, 0, 0, 0, 0, 0, 0,
                          0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                          0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x9C, 0, 0, 0, 0
                         };


 Result = Character;

 if((Character > 0x10) && (Character < 0x17))
 {
  Result = 0;
 }
 else
 {
//  if((Character > 0x1F) && (Character < 0x5E)) Result = Character;
//  else
//  {
   if(Character > 0x7F) Result = Table[Character - 0x80];
//  }
 }

 if(PltMode)
 {
  if(Result == 0)
  {
   PltPenInUse++;
   if(PltPenInUse == 4) PltPenInUse = 0;
   fprintf(PFile, "\x3;\nSP%u;LB$%02X\x3;", PltPenInUse + 1, Character);
   PltPenInUse--;
   if(PltPenInUse == 0xFF) PltPenInUse = 3;
   fprintf(PFile, "SP%u;\n", PltPenInUse + 1);
  }
 }

 return(Result);
}




void MZPIO_Write(UINT16 Address, UINT8 Data)
{
 switch(Address)
 {
  case PORTACTRL:
                  break;
  case PORTBCTRL:
                  break;
  case PORTADATA:
                  break;
  case PORTBDATA:
                  if(PltGraphMode)
                  {
                   if(PltSequence != 0)
                   {
                    if(PltSequence != 0x4000 + 'P')
                    {
                     if(PltParaIndex == 0)
                     {
                      if(Data != ' ')
                      {
                       if((isdigit(Data)) || (Data == '-'))
                       {
                        PltParameter[PltParaCounter].Value[PltParaIndex++] = Data;
                        PltParameter[PltParaCounter].Value[PltParaIndex] = 0;
                       }
                       else PltParaIsOk = FALSE;
                      }
                     }
                     else
                     {
                      if((Data == ',') || (Data == 0x0D))
                      {
                       PltParaIndex = 0;
                       PltParaCounter++;
                       PltParaIsOk = TRUE;
                      }
                      else
                      {
                       if(PltParaIsOk)
                       {
                        if(isdigit(Data))
                        {
                         if((PltParameter[PltParaCounter].Value[0] == '-') && (PltParaIndex == 4))
                         {
                          PltParameter[PltParaCounter].Value[1] = PltParameter[PltParaCounter].Value[2];
                          PltParameter[PltParaCounter].Value[2] = PltParameter[PltParaCounter].Value[3];
                          PltParameter[PltParaCounter].Value[3] = Data;
                         }
                         else
                         {
                          if((PltParameter[PltParaCounter].Value[0] != '-') && (PltParaIndex == 3))
                          {
                           PltParameter[PltParaCounter].Value[0] = PltParameter[PltParaCounter].Value[1];
                           PltParameter[PltParaCounter].Value[1] = PltParameter[PltParaCounter].Value[2];
                           PltParameter[PltParaCounter].Value[2] = Data;
                          }
                          else
                          {
                           PltParameter[PltParaCounter].Value[PltParaIndex++] = Data;
                           PltParameter[PltParaCounter].Value[PltParaIndex] = 0;
                          }
                         }
                        }
                        else PltParaIsOk = FALSE;
                       }
                      }
                     }
                    }
                                       
                    switch(PltSequence)
                    {
                     case 0x1000 + 'C': if(PltParaCounter == 1)
                                        {
                                         PltParameter[0].Value[0] = PltParameter[0].Value[0] + 1;
                                         fprintf(PFile, "SP%s;\n", PltParameter[0].Value);
                                         PltSequence = 0;
                                        }
                                        break;
                     case 0x1000 + 'L': if(PltParaCounter == 1)
                                        {
                                         switch(atoi(PltParameter[0].Value))
                                         {
                                          case 0 : fputs("LT;\n", PFile);
                                                   break;
                                          case 1 : fputs("LT1,0.2;\n", PFile);
                                                   break;
                                          default: fprintf(PFile, "LT2,%1.3f;\n", 3.0 / (16 - atoi(PltParameter[0].Value) + 1));
                                         }
                                         PltSequence = 0;
                                        }
                                        break;
                     case 0x1000 + 'Q': if(PltParaCounter == 1)
                                        {
                                         fputs("DI", PFile);
                                         switch(atoi(PltParameter[0].Value))
                                         {
                                          case 0: fputs("1,0", PFile);
                                                  break;
                                          case 1: fputs("0,-1", PFile);
                                                  break;
                                          case 2: fputs("-1,0", PFile);
                                                  break;
                                          case 3: fputs("0,1", PFile);
                                                  break;
                                         }
                                         fputs(";\n", PFile);
                                         PltSequence = 0;
                                        }
                                        break;
                     case 0x1000 + 'S': if(PltParaCounter == 1)
                                        {
                                         fprintf(PFile, "SI%1.3f,%1.3f;\n", PLTCHARWIDTH(80.0 / ((unsigned char) atoi(PltParameter[0].Value) + 1)), PLTCHARHEIGHT(80.0 / ((unsigned char) atoi(PltParameter[0].Value) + 1)));
                                         PltSequence = 0;
                                        }
                                        break;
                     case 0x2000 + 'D':
                     case 0x2000 + 'M': if(PltParaCounter == 2)
                                        {
                                         PltAbsXPos = atoi(PltParameter[0].Value) + PltHomeXPos;
                                         PltAbsYPos = atoi(PltParameter[1].Value) + PltHomeYPos;
                                         fprintf(PFile, "%d,%d", PltAbsXPos, PltAbsYPos);
                                         PltParaCounter = 0;
                                         if(Data == 0x0D)
                                         {
                                          fputs(";\n", PFile);
                                          PltSequence = 0;
                                         }
                                        }
                                        break;
                     case 0x2000 + 'J':
                     case 0x2000 + 'R': if(PltParaCounter == 2)
                                        {
                                         PltAbsXPos = PltAbsXPos + atoi(PltParameter[0].Value);
                                         PltAbsYPos = PltAbsYPos + atoi(PltParameter[1].Value);
                                         fprintf(PFile, "%d,%d", PltAbsXPos, PltAbsYPos);
                                         PltParaCounter = 0;
                                         if(Data == 0x0D)
                                         {
                                          fputs(";\n", PFile);
                                          PltSequence = 0;
                                         }
                                        }
                                        break;
                     case 0x3000 + 'X': if(PltParaCounter == 3)
                                        {
                                         PltAxis();
                                         PltSequence = 0;
                                        }
                                        break;
                     case 0x4000 + 'P': if(Data != 0x0D)
                                         fputc(TranslateSharpASCII(Data), PFile);
                                        else
                                        {
                                         fputs("\x3;\n", PFile);
                                         PltSequence = 0;
                                        }
                                        break;
                    }
                    if(PltSequence == 0) PltParaCounter = 0;
                   }
                   else
                   {
                    switch(Data)
                    {
                     case  1 :
                     case 'A': PltGraphMode = FALSE;
                               fprintf(PFile, "PU;PA0,%d;SI%1.3f,%1.3f;\n", PltAbsYPos, PLTCHARWIDTH(40), PLTCHARHEIGHT(40));
                               PltAbsXPos = 0;
                               PltHomeXPos = 0;
                               PltHomeYPos = PltAbsYPos;
                               PltSequence = 0;
                               break;
                     case 'H': fprintf(PFile, "PU;PA%d,%d;\n", PltHomeXPos, PltHomeYPos);
                               break;
                     case 'I': PltHomeXPos = PltAbsXPos;
                               PltHomeYPos = PltAbsYPos;
                               break;
                     case 'C':
                     case 'L':
                     case 'Q':
                     case 'S': PltSequence = 0x1000 + Data;
                               break;
                     case 'D': PltSequence = 0x2000 + 'D';
                               fputs("PD;PA", PFile);
                               break;
                     case 'J': PltSequence = 0x2000 + 'J';
                               fputs("PD;PA", PFile);
                               break;
                     case 'M': PltSequence = 0x2000 + 'M';
                               fputs("PU;PA", PFile);
                               break;
                     case 'R': PltSequence = 0x2000 + 'R';
                               fputs("PU;PA", PFile);
                               break;
                     case 'X': PltSequence = 0x3000 + Data;
                               break;
                     case 'P': PltSequence = 0x4000 + Data;
                               fputs("LB", PFile);
                               break;
                    }
                   }
                  }
                  else
                  {
                   switch(Data)
                   {
                    case 0x01: PltGraphMode = FALSE;
                               fprintf(PFile, "SI%1.3f,%1.3f;\n", PLTCHARWIDTH(40), PLTCHARHEIGHT(40));
                               break;
                    case 0x02: PltGraphMode = TRUE;
                               PltHomeXPos = PltAbsXPos;
                               PltHomeYPos = PltAbsYPos;
                               break;
                    case 0x03: fputs("LB\xB\3;\n", PFile);
                               break;
                    case 0x04:
                               fputs("SP1;PA16,0;PD;PR100,0,0,100,-100,0,0,-100;PU;\n", PFile);
                               fputs("SP2;PA132,0;PD;PR100,0,0,100,-100,0,0,-100;PU;\n", PFile);
                               fputs("SP3;PA248,0;PD;PR100,0,0,100,-100,0,0,-100;PU;\n", PFile);
                               fputs("SP4;PA364,0;PD;PR100,0,0,100,-100,0,0,-100;PU;\n", PFile);
                               fputs("SP1;PA0,0;", PFile);
                               fprintf(PFile, "SI%1.3f,%1.3f;\n", PLTCHARWIDTH(40), PLTCHARHEIGHT(40));
                               fputs("LB\xA\x3;\n", PFile);
                               PltPenInUse = 0;
                               break;
                    case 0x09: PltSequence++;
                               if(PltSequence == 3)
                               { // 80 chars per line
                                fprintf(PFile, "SI%1.3f,%1.3f;\n", PLTCHARWIDTH(80), PLTCHARHEIGHT(80));
                                PltSequence = 0;
                               }
                               break;
                    case 0x0B: if(PltSequence == 2)
                               { // 80->40
                                fprintf(PFile, "SI%1.3f,%1.3f;\n", PLTCHARWIDTH(40), PLTCHARHEIGHT(40));
                               }
                               else
                               {
                                fprintf(PFile, "SI%1.3f,%1.3f;\n", PLTCHARWIDTH(26), PLTCHARHEIGHT(26));
                               }
                               PltSequence = 0;
                               break;
                    case 0x0C: fprintf(PFile, "SI%1.3f,%1.3f;\n", PLTCHARWIDTH(40), PLTCHARHEIGHT(40));
                               break;
                    case 0x0D: if(PltMode) fputs("LB\xD\xA\x3;\n", PFile);
                               else fputs("\n", PFile);
                               break;
                    case 0x0E: fputs("LB\x8\x3;\n", PFile);
                               break;
                    case 0x0F: // FF
                               PltOpenNewFile();
                               break;
                    case 0x1D: PltPenInUse++;
                               if(PltPenInUse == 4) PltPenInUse = 0;
                               fprintf(PFile, "SP%u;\n", PltPenInUse + 1);
                               break;
                    default  : if(PrinterPort)
                               {
                                biosprint(_PRINTER_WRITE, Data, PrinterPort);
                               }
                               else
                               {
                                if(PltMode) fprintf(PFile, "LB%c\x3;\n", TranslateSharpASCII(Data));
                                else fputc(TranslateSharpASCII(Data), PFile);
                               }
                   }
                   if((PltSequence != 0) && (Data != 0x09)) PltSequence = 0;
                  }
                  RDAFlag = 1;
                  break;
 }
}




void InitVGA(void)
{
 union REGS Register;


 // set 200 scan lines -> 8x8 font will be activated
 Register.w.ax = 0x1200;
 Register.w.bx = 0x0030;
 int86(0x10, &Register, &Register);

 // mode 1, 40 x 25 colour mode
 // with MSB set, the screen is not cleared
 Register.w.ax = 0x0081;
 int86(0x10, &Register, &Register);

 // activate page 0
 Register.w.ax = 0x0500;
 int86(0x10, &Register, &Register);
 

 // read Cursorsize
 Register.h.ah = 0x03;
 Register.h.bh = 0x00;        // page 0
 int86(0x10, &Register, &Register);
 CursorStartLine = Register.h.ch;
 CursorEndLine = Register.h.cl;
}




void ReInitVGA(void)
{
 union REGS Register;


 // set 400 scan lines -> font changes
 Register.w.ax = 0x1202;
 Register.w.bx = 0x0030;
 int86(0x10, &Register, &Register);

 // 80 x 25 colour mode
 Register.w.ax = 0x0003;
 int86(0x10, &Register, &Register);

 Register.w.ax = 0x1114;
 Register.w.bx = 0;
 int86(0x10, &Register, &Register);


 // Cursor on
 Register.w.ax = 0x0100;
 Register.h.ch = CursorStartLine;
 Register.h.cl = CursorEndLine;
 int86(0x10, &Register, &Register);
}




void LoadMonROM(void)
{
 FILE *pROM;


 if((pROM = fopen("MZ-700.ROM","rb")) != NULL)
 {
  fread(MZMonROM, sizeof(char), 0x1000, pROM);
  fclose(pROM);
 }
 else
 {
  ReInitVGA();
  printf("Can not open MZ-700.ROM !\n");
  exit(1);
 }
}




void LoadCGROM(char *FileName)
{
 FILE *pROM;
 unsigned short i;


 if((pROM = fopen(FileName, "rb")) != NULL)
 {
  fread(MZCGROM, sizeof(char), 4096, pROM);
  fclose(pROM);

  for(i = 0; i < 4096; i++) MZCGROM[i] = Mirror(MZCGROM[i]);

  memcpy(MZCGRAM, MZCGROM, 4096);

  CGRAMToVGA();
 }
 else
 {
  ReInitVGA();
  printf("Can not open %s !\n", FileName);
  exit(1);
 }
}




void MZReset(unsigned char Type)
{
 LoadMonROM();
 
 LoadCGROM(FontFile);
 
 memset(MZExtROM, 0xFF, sizeof(MZExtROM));
 if(MZ1R12 == TRUE) LoadMZ1R12ROM();
 if(MZ1E14 == TRUE) LoadMZ1E14ROM();
 if(MZ1E05 == TRUE) LoadMZ1E05ROM();
 if(KuP_80Z == TRUE) KuP_80Z_LoadROM();

 MZMemoryBank_Write(0xE4, 0x00);

 if((Type == COLDSTART) && (MZ1R12 == TRUE)) LoadMZ1R12RAM();

 MZKBDIndex = 0;

 z80_reset();
}




void ASCIIToSharpCG(char *String)
{
 unsigned char Table[64] = { 0xF0, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
                             0x68, 0x69, 0x6B, 0x6A, 0x2F, 0x2A, 0x2E, 0x2D,
                             0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
                             0x28, 0x29, 0x4F, 0x2C, 0x51, 0x2B, 0x57, 0x49,
                             0x55, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
                             0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
                             0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
                             0x18, 0x19, 0x1A, 0x52, 0x59, 0x54, 0x67, 0xBF };
 unsigned char Pos = 0;


 while(String[Pos])
 {
  String[Pos] = toupper(String[Pos]);
  String[Pos] = Table[String[Pos] - 0x20];
  Pos++;
 }
}




void MZPrint(unsigned char XPos, unsigned char YPos, char *String)
{
 unsigned char Counter;


 if(strlen(String) == 0)
 {
  for(Counter = 0; Counter < 40; Counter++)
  {
   _farpokeb(B800, (YPos * 40 + Counter) << 1, MZVRAM[YPos * 40 + Counter]);
   _farpokeb(B800, ((YPos * 40 + Counter) << 1) + 1, MZColorToPC(MZVRAM[YPos * 40 + Counter + 0x800]));
  }
 }
 else
 {
  ASCIIToSharpCG(String);
  for(Counter = 0; String[Counter] != '\0'; Counter++)
  {
   _farpokeb(B800, (YPos * 40 + XPos + Counter) << 1, String[Counter]);
   _farpokeb(B800, ((YPos * 40 + XPos + Counter) << 1) + 1, 0x71);
  }
 }
}




unsigned char OpenCMTReadFile(unsigned char Type)
{
 char HelpFileName[41];
 char FileName[100];
 char HelpText[] = " PRESS SPACE TO TOGGLE, ENTER TO SELECT ";
 char FileMask[112];
 unsigned char Pos;

 struct ffblk FileInfo;
 int FileNotFound;
 unsigned char Ok = FALSE;
 unsigned char Result;


 Result = FALSE;
 CMTFile = NULL;

 // first check if it is a BASIC 1Z-013B LOAD "XYZ"

 Pos = 0;
 while((Pos < 17) && !Ok)
 {
  if(MZRAM[0x0FFD + Pos] == '\r')
  {
   HelpFileName[Pos] = '\0';
   if(strlen(HelpFileName) > 0) Ok = TRUE;
   else Pos = 18;
  }
  else
  {
   if(isprint(MZRAM[0x0FFD + Pos]))
   {
    HelpFileName[Pos] = MZRAM[0x0FFD + Pos];
    Pos++;
   }
   else Pos = 18;
  }
 }


 if(Ok) // it is a BASIC LOAD "XYZ"
 {
  strcpy(FileName, MZTPath);
  strcat(HelpFileName, ".MZT");
  strcat(FileName, HelpFileName);
  if((CMTFile = fopen(HelpFileName,"rb")) != NULL) return(TRUE);
 }

 if(Type == MZF)
 {
  strcpy(FileMask, MZFPath);
  strcat(FileMask, "*.MZF");
 }
 if(Type == MZT)
 {
  strcpy(FileMask, MZTPath);
  strcat(FileMask, "*.MZT");
 }

 CMTMode = CMTREADMODE;

 if(CMTFile != NULL) fclose(CMTFile);

 while(keyboard_key_down(SCAN_ENTER));

 MZPrint(0, 1, HelpText);

 while(!Ok)
 {
  FileNotFound = findfirst(FileMask, &FileInfo, FA_ARCH);
  while(!FileNotFound && !Ok)
  {
   strcpy(HelpFileName, FileInfo.ff_name);
   while(strlen(HelpFileName) < 40) strcat(HelpFileName, " ");
   MZPrint(0, 0, HelpFileName);

   while(!keyboard_key_down(SCAN_ENTER) && !keyboard_key_down(SCAN_SPACE) && !keyboard_key_down(SCAN_ESC));

   if(keyboard_key_down(SCAN_SPACE))
   {
    while(keyboard_key_down(SCAN_SPACE));
    FileNotFound = findnext(&FileInfo);
   }

   if(keyboard_key_down(SCAN_ENTER))
   {
    while(keyboard_key_down(SCAN_ENTER));
    Ok = TRUE;

    if(Type == MZT) strcpy(FileName, MZTPath);
    else strcpy(FileName, MZFPath);
    strcat(FileName, FileInfo.ff_name);

    CMTFile = fopen(FileName,"rb");

    CMTBitMask = 0x80;
    CMTReadAccess = 0;
    CMTBitClockTicks = 0;
    if(CMTFile != NULL) Result = TRUE;
   }

   if(keyboard_key_down(SCAN_ESC))
   {
    while(keyboard_key_down(SCAN_ESC));
    Ok = TRUE;
    Result = FALSE;
   }

  }
 } 

 MZPrint(0, 0, "");
 MZPrint(0, 1, "");

 return(Result);
}




void OpenCMTWriteFile(void)
{
 char FileName[14];
 unsigned char FileCounter;
 

 if(CMTFile != NULL) fclose(CMTFile);

 FileCounter = 1;
 do
 {
  sprintf(FileName, "MZ700_%02u.MZT", FileCounter++);
  CMTFile = fopen(FileName, "rb");
  if(CMTFile == NULL) FileCounter = 0;
  fclose(CMTFile);
 } while(FileCounter != 0);

 CMTFile = fopen(FileName, "wb");

 CMTMode = CMTWRITEMODE;

 CMTBitMask = 0x80;
// CMTBitClockTicks = 0;
 CMTBitShortClockTicks = 10000;
 CMTBitLongClockTicks = 0;
}




void LoadFont(void)
{
 struct ffblk FileInfo;
 int FileNotFound;
 unsigned char Ok = FALSE;
 char FileMask[] = "mz7cg*.rom";
 char HelpFileName[41];
 char HelpText[] = " PRESS SPACE TO TOGGLE, ENTER TO SELECT ";


 while(keyboard_key_down(SCAN_ENTER));

 MZPrint(0, 1, HelpText);

 while(!Ok)
 {
  FileNotFound = findfirst(FileMask, &FileInfo, FA_ARCH);
  while(!FileNotFound && !Ok)
  {
   strcpy(HelpFileName, FileInfo.ff_name);
   while(strlen(HelpFileName) < 40)
    strcat(HelpFileName, " ");
   MZPrint(0, 0, HelpFileName);

   while(!keyboard_key_down(SCAN_ENTER) && !keyboard_key_down(SCAN_SPACE) && !keyboard_key_down(SCAN_ESC));

   if(keyboard_key_down(SCAN_SPACE))
   {
    while(keyboard_key_down(SCAN_SPACE));
    FileNotFound = findnext(&FileInfo);
   }

   if(keyboard_key_down(SCAN_ENTER))
   {
    while(keyboard_key_down(SCAN_ENTER));
    Ok = TRUE;
    LoadCGROM(FileInfo.ff_name);
   }

   if(keyboard_key_down(SCAN_ESC))
   {
    while(keyboard_key_down(SCAN_ESC));
    Ok = TRUE;
   }

  }
 } 

 MZPrint(0, 0, "");
 MZPrint(0, 1, "");
}




void LoadMZFFile(unsigned char Start)
{
 struct CMTHeader *pCMTHeader;


 if(OpenCMTReadFile(MZF))
 {
  pCMTHeader = (struct CMTHeader *) &MZRAM[0x10F0];

  fread(MZRAM + 0x10F0, sizeof(struct CMTHeader), 1, CMTFile);
  fread(MZRAM + pCMTHeader->LoadAddress, pCMTHeader->Size, 1, CMTFile);

// delay(100);
  
  if(Start) (void) z80_set_reg(Z80_REG_PC, pCMTHeader->ExecAddress);
  fclose(CMTFile);
 }

 CMTFile = NULL;
}




void MakeDefaultIni(void)
{
 FILE *pIni;


 pIni = fopen("MZ-700.INI", "wt");
 fputs("[MZ-700]\n", pIni);
 fputs("\n", pIni);
 fputs("Intro=ON\n", pIni);
 fputs("BrakeValue=0\n", pIni);
 fputs("Sound=ON\n", pIni);
 fputs("Font=MZ7CGINT.ROM\n", pIni);
 fputs("JoyStick1=0,0,0,0,0,0\n", pIni);
 fputs("JoyStick2=0,0,0,0,0,0\n", pIni);
 fputs("MZFPath=\n", pIni);
 fputs("MZTPath=\n", pIni);

 fputs("\n[MZ-1R12]\n", pIni);
 fputs("1R12=OFF\n", pIni);

 fputs("\n[MZ-1E14]\n", pIni);
 fputs("1E14=OFF\n", pIni);
 fputs("QDDRIVE=\n", pIni);

 fputs("\n[MZ-1E05]\n", pIni);
 fputs("1E05=OFF\n", pIni);
 fputs("FD1=\n", pIni);
 fputs("FD2=\n", pIni);

 fputs("\n[MZ-1E24]\n", pIni);
 fputs("1E24=OFF\n", pIni);
 fputs("BAUDRATE1=9600\n", pIni);
 fputs("BAUDRATE2=9600\n", pIni);

 fputs("\n[KuP]\n", pIni);
 fputs("KuP_80Z=OFF\n", pIni);

 fclose(pIni);
}




void ProcessIniFile(void)
{
 FILE *pIni;
 char Line[80];
 char *pLine, *pPos;
 unsigned char Counter;
 

 for(Counter = 0; Counter < 4; Counter++)
  JoyCenter[Counter] = 0;

 if((pIni = fopen("MZ-700.INI","rt")) != NULL)
 { 
  while(fgets(Line, 80, pIni) != NULL)
  {
   pPos = strchr(Line, '\n');
   if(pPos != NULL) *pPos = '\0';
   strupr(Line);
   if(strncmp(Line, "INTRO", 5) == 0)
    if(strstr(Line, "OFF")) IntroOn = FALSE;
   if(strncmp(Line, "BRAKEVALUE", 10) == 0)
    BrakeValue = atoi(strchr(Line, '=') + 1);
   if(strncmp(Line, "SOUND", 5) == 0)
    if(strstr(Line, "OFF")) SoundOn = FALSE;
   if(strncmp(Line, "FONT", 4) == 0)
    strcpy(FontFile, strchr(Line, '=') + 1);
   if(strncmp(Line, "JOYSTICK1", 9) == 0)
   {
    pLine = Line;
    pLine = strchr(pLine, '=') + 1;
    JoyMinimum[0] = atoi(pLine);
    pLine = strchr(pLine, ',') + 1;
    JoyCenter[0] = atoi(pLine);
    if(JoyCenter[0] != 0) JoyStickInitOn = FALSE;
    pLine = strchr(pLine, ',') + 1;
    JoyMaximum[0] = atoi(pLine);
    pLine = strchr(pLine, ',') + 1;
    JoyMinimum[1] = atoi(pLine);
    pLine = strchr(pLine, ',') + 1;
    JoyCenter[1] = atoi(pLine);
    if(JoyCenter[1] != 0) JoyStickInitOn = FALSE;
    pLine = strchr(pLine, ',') + 1;
    JoyMaximum[1] = atoi(pLine);
   }
   if(strncmp(Line, "JOYSTICK2", 9) == 0)
   {
    pLine = Line;
    pLine = strchr(pLine, '=') + 1;
    JoyMinimum[2] = atoi(pLine);
    pLine = strchr(pLine, ',') + 1;
    JoyCenter[2] = atoi(pLine);
    if(JoyCenter[2] != 0) JoyStickInitOn = FALSE;
    pLine = strchr(pLine, ',') + 1;
    JoyMaximum[2] = atoi(pLine);
    pLine = strchr(pLine, ',') + 1;
    JoyMinimum[3] = atoi(pLine);
    pLine = strchr(pLine, ',') + 1;
    JoyCenter[3] = atoi(pLine);
    if(JoyCenter[3] != 0) JoyStickInitOn = FALSE;
    pLine = strchr(pLine, ',') + 1;
    JoyMaximum[3] = atoi(pLine);
   }
   if(strncmp(Line, "1R12", 4) == 0)
    if(strstr(Line, "ON")) MZ1R12 = TRUE;
   if(strncmp(Line, "1E14", 4) == 0)
    if(strstr(Line, "ON")) MZ1E14 = TRUE;
   if(strncmp(Line, "1E05", 4) == 0)
    if(strstr(Line, "ON")) MZ1E05 = TRUE;
   if(strncmp(Line, "MZFPATH", 7) == 0)
   {
    pLine = Line;
    pLine = strchr(pLine, '=') + 1;
    strcpy(MZFPath, pLine);
    if(strlen(MZFPath) > 0)
    {
     if(MZFPath[strlen(MZFPath)] != '\\') strcat(MZFPath, "\\");
    }
   }
   if(strncmp(Line, "MZTPATH", 7) == 0)
   {
    pLine = Line;
    pLine = strchr(pLine, '=') + 1;
    strcpy(MZTPath, pLine);
    if(strlen(MZTPath) > 0)
    {
     if(MZTPath[strlen(MZTPath)] != '\\') strcat(MZTPath, "\\");
    }
   }
   if(strncmp(Line, "QDDRIVE", 6) == 0)
   {
    pLine = Line;
    pLine = strchr(pLine, '=') + 1;
    QDFileName[0] = *pLine;
   }
   if(strncmp(Line, "FD1", 3) == 0)
   {
    if(strstr(Line, "A"))
    {
     MZ1E05FD[0] = 0;
     MZ1E05FD[2] = 0;
    }
    else
    {
     MZ1E05FD[0] = 1;
     MZ1E05FD[2] = 1;
    }
   }
   if(strncmp(Line, "FD2", 3) == 0)
   {
    if(strstr(Line, "A"))
    {
     MZ1E05FD[1] = 0;
     MZ1E05FD[3] = 0;
    }
    else
    {
     MZ1E05FD[1] = 1;
     MZ1E05FD[3] = 1;
    }
   }
   
   if(strncmp(Line, "1E24", 4) == 0)
    if(strstr(Line, "ON")) MZ1E24 = TRUE;
   if(strncmp(Line, "BAUDRATE", 8) == 0)
   {
    MZ1E24_Baudrate[Line[8] - '1'] = atoi(strstr(Line, "=") + 1);
   }
   

   if(strncmp(Line, "KuP_80Z", 7) == 0)
    if(strstr(Line, "ON")) KuP_80Z = TRUE;
  }
  fclose(pIni);
 }
 else MakeDefaultIni();

}




void UpdateIni(char *NewLine)
{
 FILE *pOrgIni;
 FILE *pNewIni;
 char OrgLine[80];
 char *Line;


 if((pOrgIni = fopen("MZ-700.INI","rt")) != NULL)
 {
  if((pNewIni = fopen("MZ-700.ONO","wt")) != NULL)
  {
   while(fgets(OrgLine, 80, pOrgIni))
   {
    if(strncmp(OrgLine, NewLine, strchr(NewLine, '=') - NewLine) == 0) Line = NewLine;
    else Line = OrgLine;
    fputs(Line, pNewIni);
   }
   fclose(pNewIni);
  }
  fclose(pOrgIni);
 }
 remove("MZ-700.INI");
 rename("MZ-700.ONO", "MZ-700.INI");
}




void Intro(void)
{
 clrscr();
 puts("");
 printf("                             MZ-700 Emulator V %s\n", VERSION);
 puts("");
 puts("                               (c) 1998-2003 BKK");
 puts("");
 puts("                                   powered by");
 puts("");
 puts("          RAZE Z80 core, by Richard Mitton (richard.mitton@bigfoot.com)");
 puts("");
 puts("");
 puts("  F8  : Load an alternative fontfile (MZ7CG*.ROM)");
 puts("  F9  : Direct load and execute a MZF file ");
 puts("  F10 : Direct load a MZF file");
 puts("  F11 : Slow down the emulation");
 puts("  F12 : Speed up the emulation");
 puts("  ScrollLock : Playkey of the tape");
 puts("  Pause      : Stopkey of the tape");
 puts("");
 puts("  Home : Reset      End : Exit the emulator");
 puts("");
 printf("  Sound  : %s  Brakevalue: %4u   Printer: %s%c     Font: %s\n", SoundOn ? "ON ":"OFF", BrakeValue, PrinterPort ? "LPT":"MZ700.PRN", PrinterPort ? PrinterPort + '0':' ', FontFile);
 printf("  MZ-1R12: %s  MZ-1E14: %s  MZ-1E05: %s  MZ-1E24: %s  K&P80Z: %s\n", MZ1R12 ? "ON " : "OFF", MZ1E14 ? "ON " : "OFF", MZ1E05 ? "ON " : "OFF", MZ1E24 ? "ON " : "OFF", KuP_80Z ? "ON " : "OFF");
 puts("");
 puts("                           To start press any key ...");
 (void) getkey();
}




void Usage(void)
{
 puts("");
 printf("MZ-700 Emulator (c) 1998-2003 by BKK V %s\n", VERSION);
 puts("");
 puts("Usage:");
 puts("");
 puts("MZ-700 [-h] [-soff] [-ioff] [-bx] [-fxyz.rom] [-j] [-ppx] [-pmprinter] [-1R12] [-1E14]");
 puts("");
 puts("  -h             show this help");
 puts("  -soff          sound off, default is on");
 puts("  -ioff          intro off, default is on");
 puts("  -bx            set brakevalue, default is 0");
 puts("  -fxyz.rom      the fontfile xyz.rom will be used, default is MZ7CGInt.ROM");
 puts("  -j             test and calibrate the joystick");
 puts("  -pmprinter     printermode is set to printer, default is plotter");
 puts("  -ppx           printerport is set to x [1..3], default is print to file");
 puts("  -1R12          enables the use of the MZ-1R12 emulation, default is off");
 puts("  -1E14          enables the use of the MZ-1E14 emulation, default is off");
 puts("  -1E05          enables the use of the MZ-1E05 emulation, default is off");
 puts("  -1E24          enables the use of the MZ-1E24 emulation, default is off");
 puts("  -80z           enables the use of the K&P 80 character card, default is off");
 puts("");
 exit(1);
}




int main(int argc, char *argv[])
{
 UINT8 Exit;
 UINT32 Prior;
//        Z80Status;

 UINT16 BrakeCounter;

 unsigned char i;
 unsigned char TempTimer = 13;
 unsigned char VBlankTimer = 20;
 unsigned int CursorTimer = 331;

 char BrakeValueString[40];


#ifdef DEBUG
 DebugFile = fopen("MZ-700.DBG", "wt");
#endif



 Exit = FALSE;

 ProcessIniFile();

 for(i = 1; i < argc; i++)
 {
  strlwr(argv[i]);
  if(strcmp(argv[i], "-h") == 0) Usage();
  else
   if(strcmp(argv[i], "-soff") == 0) SoundOn = FALSE;
   else
    if(strcmp(argv[i], "-ioff") == 0) IntroOn = FALSE;
    else
     if(strncmp(argv[i], "-b", 2) == 0) BrakeValue = atoi(&argv[i][2]);
     else
      if(strncmp(argv[i], "-f", 2) == 0) strcpy(FontFile, &argv[i][2]);
      else
       if(strcmp(argv[i], "-j") == 0) JoyStickInitOn = TRUE;
       else
        if(strncmp(argv[i], "-pp", 3) == 0) PrinterPort = atoi(&argv[i][2]);
        else
         if(strncmp(argv[i], "-pmprinter", 7) == 0) PltMode = FALSE;
         else
          if(strncmp(argv[i], "-1r12", 6) == 0) MZ1R12 = TRUE;
          else
           if(strncmp(argv[i], "-1e14", 6) == 0) MZ1E14 = TRUE;
           else
            if(strncmp(argv[i], "-1e05", 6) == 0) MZ1E05 = TRUE;
            else
             if(strncmp(argv[i], "-1e24", 6) == 0) MZ1E24 = TRUE;
             else
              if(strncmp(argv[i], "-80z", 6) == 0) KuP_80Z = TRUE;
              else
              Usage();
 }

 if(JoyStickInitOn) InitJoyStick();

 if(PrinterPort)
 {
  biosprint(_PRINTER_INIT, 0, PrinterPort);
 }
 else
 { 
  if(PltMode)
  {
   PltClearFiles();
   PltOpenNewFile();
  }
  else PFile = fopen("MZ-700.PRN", "wb");
 }

 if(IntroOn) Intro();

 B800 = __dpmi_segment_to_descriptor(0xB800);



 z80_init_memmap();
  z80_map_fetch(0x0000, 0x0FFF, &MZMonROM[0x0000]);
  z80_map_fetch(0x1000, 0xDFFF, &MZRAM[0x1000]);
  z80_map_fetch(0xE000, 0xFFFF, &MZExtROM[0x0000]);

  z80_map_read(0x0000, 0x0FFF, &MZMonROM[0x0000]);
  z80_map_read(0x1000, 0x1FFF, &MZRAM[0x1000]);
  z80_add_read(0x2000, 0xBFFF, Z80_MAP_DIRECT, &MZRAM[0x2000]);
  z80_map_read(0xC000, 0xCFFF, &MZRAM[0xC000]);
  z80_map_read(0xD000, 0xDFFF, &MZVRAM[0]);
  z80_add_read(0xE000, 0xE0FF, Z80_MAP_HANDLED, &MZRAMDFRead);
  z80_map_read(0xE100, 0xFFFF, &MZExtROM[0x0100]);

  z80_add_write(0x0000, 0xBFFF, Z80_MAP_DIRECT, &MZRAM[0x0000]);
  z80_map_write(0xC000, 0xCFFF, &MZRAM[0xC000]);
  z80_add_write(0xD000, 0xDFFF, Z80_MAP_HANDLED, &MZRAMWriteDE);
  z80_add_write(0xE000, 0xE0FF, Z80_MAP_HANDLED, &MZRAMWriteEF);
  z80_add_write(0xE100, 0xFFFF, Z80_MAP_DIRECT, &MZRAM[0xE100]);

  z80_set_in(&IO_Read);
  z80_set_out(&IO_Write);
 z80_end_memmap();


 if(keyboard_init())
 {
  printf("KBD Error\n");
  exit(-1);
 }

 while(kbhit()) getch();

 keyboard_chain(KEYBOARDCHAINOFF);      // disable the original handler
 keyboard_led(NONELED);                 // all LED's off

 InitVGA();                             // change video mode
 MZReset(COLDSTART);                    // load ROM's and init RAM banks
 
 InitVGA();
 CGRAMToVGA();


 Prior = 0;


 New1EIntAddr.segment = __dpmi_allocate_dos_memory(3, &New1ESelector);
 New1EIntAddr.offset16 = 0;
 _dosmemputb(New1EInt, sizeof(New1EInt), New1EIntAddr.segment * 16);
 __dpmi_get_real_mode_interrupt_vector(0x1E, &Org1EIntAddr);
 __dpmi_set_real_mode_interrupt_vector(0x1E, &New1EIntAddr);


 while(Exit == FALSE)
 {
  VBlank = FALSE;

  ClockTicks = z80_emulate(293);

  Z80ClockTicks += ClockTicks;
  CMTBitClockTicks += ClockTicks;


  if(BrakeValue != 0)
   for(BrakeCounter = BrakeValue; BrakeCounter != 0; BrakeCounter--)
    (void) inportb(0x80);         // dummy to slow down the emulation


  if((CounterMode != 0) && (ReadWriteMSB == FALSE))
  {
   if(--Counter1Value == 0)
   {
    Counter1Value = Counter1Init;
    if((--Counter2Value == 0) && INTMSK)
    {
     z80_raise_IRQ(0xFF);
     z80_lower_IRQ();
     Counter2Value = Counter2Init;
    }
   }
  }


  if(Z80ClockTicks > 3530)      // execute every ms (3530 * 64us)
  {
   Z80ClockTicks = 0;

   if(TempTimer != 0) TempTimer--;
   else
   {
    E008_Strobe ^= 1;    // Temp f = 38,17464Hz T = 0,026195s
    TempTimer = 13;      // change every 13ms
   }


   if(VBlankTimer != 0) VBlankTimer--; // VBlank every 20ms
   else
   {
    VBlank = TRUE;
    VBlankTimer = 20;
   }


   if(CursorTimer != 0) CursorTimer--;
   else
   {
    CursorBlink = ~CursorBlink;  // Cursor f = 1,511Hz  T = 0,661815s
    CursorTimer = 331;           // change every 331ms

    if(keyboard_key_down(SCAN_F11))
    {
     sprintf(BrakeValueString, " Brakevalue: %5u ", BrakeValue);
     MZPrint(0,24,BrakeValueString);
     delay(1000);
     while(keyboard_key_down(SCAN_F11) && BrakeValue != 0xFFFF)
     {
      BrakeValue++;
      BrakeValueChanged = TRUE;
      sprintf(BrakeValueString, " Brakevalue: %5u ", BrakeValue);
      MZPrint(0,24,BrakeValueString);
      delay(100);
     }
     MZPrint(0,24,"");
    }

    if(keyboard_key_down(SCAN_F12))
    {
     sprintf(BrakeValueString, " Brakevalue: %5u ", BrakeValue);
     MZPrint(0,24,BrakeValueString);
     delay(1000);
     while(keyboard_key_down(SCAN_F12) && BrakeValue != 0)
     {
      BrakeValue--;
      BrakeValueChanged = TRUE;
      sprintf(BrakeValueString, " Brakevalue: %5u ", BrakeValue);
      MZPrint(0,24,BrakeValueString);
      delay(100);
     }
     MZPrint(0,24,"");
    }
   }


   if(keyboard_key_down(SCAN_END)) Exit = 1;
   if(keyboard_key_down(SCAN_F8)) LoadFont();
   if(keyboard_key_down(SCAN_F9)) LoadMZFFile(LOADANDEXECUTE);
   if(keyboard_key_down(SCAN_F10)) LoadMZFFile(LOADONLY);
   if(keyboard_key_down(SCAN_HOME)) MZReset(WARMSTART);


   if(KuP_80Z)
   {
    if(keyboard_key_down(SCAN_NUMLOCK))
    {
     while(keyboard_key_down(SCAN_NUMLOCK));
     if(KuP_80Z_Active)
     {
      InitVGA();
      CGRAMToVGA();
      KuP_80Z_Active = FALSE;
     }
     else KuP_80Z_Activate();
    }
   }


   if(PlayPressed)
   {
    if(keyboard_key_down(SCAN_PAUSE))
    {
     PlayPressed = FALSE;
     keyboard_led(NONELED);
     M_STATUS = MOTORSTOP;
     fclose(CMTFile);
     CMTFile = NULL;
    }
   }
   else
   {
    if(keyboard_key_down(SCAN_SCRLOCK))
    {
     PlayPressed = TRUE;
     keyboard_led(SCROLLLOCKLED + CAPSLOCKLED);
     M_STATUS = MOTORON;
    }
   }
  }

 }


 __dpmi_set_real_mode_interrupt_vector(0x1E, &Org1EIntAddr);
 __dpmi_free_dos_memory(New1ESelector);

 nosound();
 keyboard_chain(1);     // enable the original handler
 keyboard_reset();      // to initialize the LED's
 keyboard_close();      // restore the original handler

 if(CMTFile != NULL) fclose(CMTFile);
 if(PFile != NULL) fclose(PFile);

 if(MZ1R12 == TRUE) SaveMZ1R12RAM();

 ReInitVGA();           // restore the original textmode

 if(BrakeValueChanged)
 {
  sprintf(BrakeValueString, "BrakeValue=%u\n", BrakeValue);
  UpdateIni(BrakeValueString);
 }

#ifdef DEBUG
 fclose(DebugFile);
#endif

 return 0;
}

